<?php
/**
 * Add Theme info Page
 */

function nutriflux_fse_menu() {
	add_theme_page( esc_html__( 'Nutriflux FSE', 'nutriflux-fse' ), esc_html__( 'About Nutriflux FSE', 'nutriflux-fse' ), 'edit_theme_options', 'about-nutriflux-fse', 'nutriflux_fse_theme_page_display' );
}
add_action( 'admin_menu', 'nutriflux_fse_menu' );

function nutriflux_fse_admin_theme_style() {
	wp_enqueue_style('nutriflux-fse-custom-admin-style', esc_url(get_template_directory_uri()) . '/assets/css/admin-styles.css');
}
add_action('admin_enqueue_scripts', 'nutriflux_fse_admin_theme_style');

/**
 * Display About page
 */
function nutriflux_fse_theme_page_display() {
	$theme = wp_get_theme();

	if ( is_child_theme() ) {
		$theme = wp_get_theme()->parent();
	} ?>

		<div class="Grace-wrapper">
			<div class="Grcae-info-holder">
				<div class="Grcae-info-holder-content">
					<div class="Grace-Welcome">
						<h1 class="welcomeTitle"><?php esc_html_e( 'About Theme Info', 'nutriflux-fse' ); ?></h1>                        
						<div class="featureDesc">
							<?php echo esc_html__( 'The Nutriflux FSE is a free Dietitian WordPress theme for dietitians, wellness & health center, personal coach, fitness trainer, weight loss centre, fitness instructors, yoga therapists.', 'nutriflux-fse' ); ?>
						</div>
						
                        <h1 class="welcomeTitle"><?php esc_html_e( 'Theme Features', 'nutriflux-fse' ); ?></h1>

                        <h2><?php esc_html_e( 'Block Compatibale', 'nutriflux-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The built-in customizer panel quickly change aspects of the design and display changes live before saving them.', 'nutriflux-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Responsive Ready', 'nutriflux-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The themes layout will automatically adjust and fit on any screen resolution and looks great on any device. Fully optimized for iPhone and iPad.', 'nutriflux-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Cross Browser Compatible', 'nutriflux-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Our themes are tested in all mordern web browsers and compatible with the latest version including Chrome,Firefox, Safari, Opera, IE11 and above.', 'nutriflux-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'E-commerce', 'nutriflux-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Fully compatible with WooCommerce plugin. Just install the plugin and turn your site into a full featured online shop and start selling products.', 'nutriflux-fse' ); ?>
                        </div>

					</div> <!-- .Grace-Welcome -->
				</div> <!-- .Grcae-info-holder-content -->
				
				
				<div class="Grcae-info-holder-sidebar">
                        <div class="sidebarBX">
                            <h2 class="sidebarBX-title"><?php echo esc_html__( 'Get Nutriflux PRO', 'nutriflux-fse' ); ?></h2>
                            <p><?php echo esc_html__( 'More features availbale on Premium version', 'nutriflux-fse' ); ?></p>
                            <a href="<?php echo esc_url( 'https://gracethemes.com/themes/nutritionist-wordpress-theme/' ); ?>" target="_blank" class="button"><?php esc_html_e( 'Get the PRO Version &rarr;', 'nutriflux-fse' ); ?></a>
                        </div>


						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Important Links', 'nutriflux-fse' ); ?></h2>

							<ul class="themeinfo-links">
                                <li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/nutriflux/' ); ?>" target="_blank"><?php echo esc_html__( 'Demo Preview', 'nutriflux-fse' ); ?></a>
								</li>                               
								<li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/documentation/nutriflux/#homepage-lite' ); ?>" target="_blank"><?php echo esc_html__( 'Documentation', 'nutriflux-fse' ); ?></a>
								</li>
								
								<li>
									<a href="<?php echo esc_url( 'https://gracethemes.com/wordpress-themes/' ); ?>" target="_blank"><?php echo esc_html__( 'View Our Premium Themes', 'nutriflux-fse' ); ?></a>
								</li>
							</ul>
						</div>

						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Leave us a review', 'nutriflux-fse' ); ?></h2>
							<p><?php echo esc_html__( 'If you are satisfied with Nutriflux FSE, please give your feedback.', 'nutriflux-fse' ); ?></p>
							<a href="https://wordpress.org/support/theme/nutriflux-fse/reviews/" class="button" target="_blank"><?php esc_html_e( 'Submit a review', 'nutriflux-fse' ); ?></a>
						</div>

				</div><!-- .Grcae-info-holder-sidebar -->	

			</div> <!-- .Grcae-info-holder -->
		</div><!-- .Grace-wrapper -->
<?php } ?>