<?php
/**
 * Add Theme info Page
 */

function ecolife_park_fse_menu() {
	add_theme_page( esc_html__( 'Ecolife Park FSE', 'ecolife-park-fse' ), esc_html__( 'About Ecolife Park FSE', 'ecolife-park-fse' ), 'edit_theme_options', 'about-ecolife-park-fse', 'ecolife_park_fse_theme_page_display' );
}
add_action( 'admin_menu', 'ecolife_park_fse_menu' );

function ecolife_park_fse_admin_theme_style() {
	wp_enqueue_style('ecolife-park-fse-custom-admin-style', esc_url(get_template_directory_uri()) . '/assets/css/admin-styles.css');
}
add_action('admin_enqueue_scripts', 'ecolife_park_fse_admin_theme_style');

/**
 * Display About page
 */
function ecolife_park_fse_theme_page_display() {
	$theme = wp_get_theme();

	if ( is_child_theme() ) {
		$theme = wp_get_theme()->parent();
	} ?>

		<div class="Grace-wrapper">
			<div class="Grcae-info-holder">
				<div class="Grcae-info-holder-content">
					<div class="Grace-Welcome">
						<h1 class="welcomeTitle"><?php esc_html_e( 'About Theme Info', 'ecolife-park-fse' ); ?></h1>                        
						<div class="featureDesc">
							<?php echo esc_html__( 'Free safari WordPress theme for safari, zoo, aquarium, non-profit, ecology, environment, animal protection, animal rescue, wildlife experience.', 'ecolife-park-fse' ); ?>
						</div>
						
                        <h1 class="welcomeTitle"><?php esc_html_e( 'Theme Features', 'ecolife-park-fse' ); ?></h1>

                        <h2><?php esc_html_e( 'Block Compatibale', 'ecolife-park-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The built-in customizer panel quickly change aspects of the design and display changes live before saving them.', 'ecolife-park-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Responsive Ready', 'ecolife-park-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The themes layout will automatically adjust and fit on any screen resolution and looks great on any device. Fully optimized for iPhone and iPad.', 'ecolife-park-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Cross Browser Compatible', 'ecolife-park-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Our themes are tested in all mordern web browsers and compatible with the latest version including Chrome,Firefox, Safari, Opera, IE11 and above.', 'ecolife-park-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'E-commerce', 'ecolife-park-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Fully compatible with WooCommerce plugin. Just install the plugin and turn your site into a full featured online shop and start selling products.', 'ecolife-park-fse' ); ?>
                        </div>

					</div> <!-- .Grace-Welcome -->
				</div> <!-- .Grcae-info-holder-content -->
				
				
				<div class="Grcae-info-holder-sidebar">
                        <div class="sidebarBX">
                            <h2 class="sidebarBX-title"><?php echo esc_html__( 'Get Ecolife Park PRO', 'ecolife-park-fse' ); ?></h2>
                            <p><?php echo esc_html__( 'More features availbale on Premium version', 'ecolife-park-fse' ); ?></p>
                            <a href="<?php echo esc_url( 'https://gracethemes.com/themes/wildlife-wordpress-theme/' ); ?>" target="_blank" class="button"><?php esc_html_e( 'Get the PRO Version &rarr;', 'ecolife-park-fse' ); ?></a>
                        </div>


						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Important Links', 'ecolife-park-fse' ); ?></h2>

							<ul class="themeinfo-links">
                                <li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/ecolife-park/' ); ?>" target="_blank"><?php echo esc_html__( 'Demo Preview', 'ecolife-park-fse' ); ?></a>
								</li>                               
								<li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/documentation/ecolife-park/#homepage-lite' ); ?>" target="_blank"><?php echo esc_html__( 'Documentation', 'ecolife-park-fse' ); ?></a>
								</li>
								
								<li>
									<a href="<?php echo esc_url( 'https://gracethemes.com/wordpress-themes/' ); ?>" target="_blank"><?php echo esc_html__( 'View Our Premium Themes', 'ecolife-park-fse' ); ?></a>
								</li>
							</ul>
						</div>

						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Leave us a review', 'ecolife-park-fse' ); ?></h2>
							<p><?php echo esc_html__( 'If you are satisfied with Ecolife Park FSE, please give your feedback.', 'ecolife-park-fse' ); ?></p>
							<a href="https://wordpress.org/support/theme/ecolife-park-fse/reviews/" class="button" target="_blank"><?php esc_html_e( 'Submit a review', 'ecolife-park-fse' ); ?></a>
						</div>

				</div><!-- .Grcae-info-holder-sidebar -->	

			</div> <!-- .Grcae-info-holder -->
		</div><!-- .Grace-wrapper -->
<?php } ?>