<?php
/**
 * Add Theme info Page
 */

function divineyoga_fse_menu() {
	add_theme_page( esc_html__( 'DivineYoga FSE', 'divineyoga-fse' ), esc_html__( 'About DivineYoga FSE', 'divineyoga-fse' ), 'edit_theme_options', 'about-divineyoga-fse', 'divineyoga_fse_theme_page_display' );
}
add_action( 'admin_menu', 'divineyoga_fse_menu' );

function divineyoga_fse_admin_theme_style() {
	wp_enqueue_style('divineyoga-fse-custom-admin-style', esc_url(get_template_directory_uri()) . '/assets/css/admin-styles.css');
}
add_action('admin_enqueue_scripts', 'divineyoga_fse_admin_theme_style');

/**
 * Display About page
 */
function divineyoga_fse_theme_page_display() {
	$theme = wp_get_theme();

	if ( is_child_theme() ) {
		$theme = wp_get_theme()->parent();
	} ?>

		<div class="Grace-wrapper">
			<div class="Grcae-info-holder">
				<div class="Grcae-info-holder-content">
					<div class="Grace-Welcome">
						<h1 class="welcomeTitle"><?php esc_html_e( 'About Theme Info', 'divineyoga-fse' ); ?></h1>                        
						<div class="featureDesc">
							<?php echo esc_html__( 'DivineYoga FSE is a free yoga WordPress theme perfect for yoga instructors, wellness centers, meditation practices, health-focused businesses and spiritual healing websites.', 'divineyoga-fse' ); ?>
						</div>
						
                        <h1 class="welcomeTitle"><?php esc_html_e( 'Theme Features', 'divineyoga-fse' ); ?></h1>

                        <h2><?php esc_html_e( 'Block Compatibale', 'divineyoga-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The built-in customizer panel quickly change aspects of the design and display changes live before saving them.', 'divineyoga-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Responsive Ready', 'divineyoga-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'The themes layout will automatically adjust and fit on any screen resolution and looks great on any device. Fully optimized for iPhone and iPad.', 'divineyoga-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'Cross Browser Compatible', 'divineyoga-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Our themes are tested in all mordern web browsers and compatible with the latest version including Chrome,Firefox, Safari, Opera, IE11 and above.', 'divineyoga-fse' ); ?>
                        </div>
                        
                        <h2><?php esc_html_e( 'E-commerce', 'divineyoga-fse' ); ?></h2>
                        <div class="featureDesc">
                            <?php echo esc_html__( 'Fully compatible with WooCommerce plugin. Just install the plugin and turn your site into a full featured online shop and start selling products.', 'divineyoga-fse' ); ?>
                        </div>

					</div> <!-- .Grace-Welcome -->
				</div> <!-- .Grcae-info-holder-content -->
				
				
				<div class="Grcae-info-holder-sidebar">
                        <div class="sidebarBX">
                            <h2 class="sidebarBX-title"><?php echo esc_html__( 'Get DivineYoga PRO', 'divineyoga-fse' ); ?></h2>
                            <p><?php echo esc_html__( 'More features availbale on Premium version', 'divineyoga-fse' ); ?></p>
                            <a href="<?php echo esc_url( 'https://gracethemes.com/themes/spiritual-wordpress-theme/' ); ?>" target="_blank" class="button"><?php esc_html_e( 'Get the PRO Version &rarr;', 'divineyoga-fse' ); ?></a>
                        </div>


						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Important Links', 'divineyoga-fse' ); ?></h2>

							<ul class="themeinfo-links">
                                <li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/divineyoga/' ); ?>" target="_blank"><?php echo esc_html__( 'Demo Preview', 'divineyoga-fse' ); ?></a>
								</li>                               
								<li>
									<a href="<?php echo esc_url( 'https://gracethemesdemo.com/documentation/divineyoga/#homepage-lite' ); ?>" target="_blank"><?php echo esc_html__( 'Documentation', 'divineyoga-fse' ); ?></a>
								</li>
								
								<li>
									<a href="<?php echo esc_url( 'https://gracethemes.com/wordpress-themes/' ); ?>" target="_blank"><?php echo esc_html__( 'View Our Premium Themes', 'divineyoga-fse' ); ?></a>
								</li>
							</ul>
						</div>

						<div class="sidebarBX">
							<h2 class="sidebarBX-title"><?php echo esc_html__( 'Leave us a review', 'divineyoga-fse' ); ?></h2>
							<p><?php echo esc_html__( 'If you are satisfied with DivineYoga FSE, please give your feedback.', 'divineyoga-fse' ); ?></p>
							<a href="https://wordpress.org/support/theme/divineyoga-fse/reviews/" class="button" target="_blank"><?php esc_html_e( 'Submit a review', 'divineyoga-fse' ); ?></a>
						</div>

				</div><!-- .Grcae-info-holder-sidebar -->	

			</div> <!-- .Grcae-info-holder -->
		</div><!-- .Grace-wrapper -->
<?php } ?>